/*
 * lcn20PHY RADIO control module interface (to other PHY modules).
 *
 * Copyright (C) 2015, Broadcom Corporation
 * All Rights Reserved.
 * 
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Broadcom Corporation.
 *
 * $Id$
 */

#ifndef _phy_lcn20_radio_h_
#define _phy_lcn20_radio_h_

#include <phy_api.h>
#include <phy_lcn20.h>
#include <phy_radio.h>

/* forward declaration */
typedef struct phy_lcn20_radio_info phy_lcn20_radio_info_t;

/* register/unregister lcn20PHY specific implementations to/from common */
phy_lcn20_radio_info_t *phy_lcn20_radio_register_impl(phy_info_t *pi,
	phy_lcn20_info_t *lcn20i, phy_radio_info_t *ri);
void phy_lcn20_radio_unregister_impl(phy_lcn20_radio_info_t *info);

void phy_lcn20_radio_switch(phy_lcn20_radio_info_t *info, bool on);

uint32 phy_lcn20_radio_query_idcode(phy_info_t *pi);
void phy_lcn20_radio_parse_idcode(phy_info_t *pi, uint32 idcode);
#endif /* _phy_lcn20_radio_h_ */
